/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul.mixin;

import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.vinlanx.gunfireoverhaul.ServerGunfireHandler;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GunItem.class}, remap=false)
public abstract class GunItemMixin {
    @Inject(method={"playFireSounds"}, at={@At(value="HEAD")})
    private void gunfireoverhaul$onPlayFireSounds(GunData data, @Nullable Entity shooter, boolean zoom, CallbackInfo ci) {
        if (shooter == null || shooter.m_9236_().m_5776_() || !(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingShooter = (LivingEntity)shooter;
        AmmoConsumer consumer = data.selectedAmmoConsumer();
        if (consumer.type != AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
            return;
        }
        Ammo ammoType = consumer.getPlayerAmmoType();
        String caliberId = this.mapAmmoTypeToCaliber(ammoType);
        if (caliberId != null) {
            ServerGunfireHandler.handleGunfireEvent(livingShooter.m_9236_(), livingShooter, livingShooter.m_20182_(), caliberId);
        }
    }

    private String mapAmmoTypeToCaliber(Ammo ammoType) {
        if (ammoType == null) {
            return null;
        }
        return switch (ammoType) {
            case Ammo.HANDGUN -> "9mm";
            case Ammo.RIFLE -> "762x39";
            case Ammo.SHOTGUN -> "12g";
            case Ammo.SNIPER -> "308";
            case Ammo.HEAVY -> "50bmg";
            default -> null;
        };
    }
}

